<!DOCTYPE html>
<html lang="en">

<!-- FM累積流量 -->

<head>
	<meta charset="UTF-8">
	<title>月報表 - 壓力計</title>
	<?php $v = rand(0, 10000); ?>
	<link rel="stylesheet" href="./style.css?<?php echo $v; ?>">
	<!-- 菜單 -->
	<link rel="stylesheet" href="./menu_style.css?<?php echo $v; ?>">
	<!-- 按鈕 -->
	<link rel="stylesheet" href="../button/style.css?<?php echo $v; ?>">
	<link href="https://fonts.googleapis.com/css2?family=Lato&display=swap" rel="stylesheet">
	<!-- 選擇器 -->
	<link rel="stylesheet" href="../select_button/style.css?<?php echo $v; ?>">
	<!-- submit 按鈕 -->
	<link href='https://fonts.googleapis.com/css?family=Roboto:400,500' rel='stylesheet' type='text/css'>
	<link rel="stylesheet" href="../submit/style.css?<?php echo $v; ?>">
	<!-- 列印 -->
	<link rel="stylesheet" href="../print/style.css?<?php echo $v; ?>">
	<?php require_once("../sql_connect.inc"); ?>
	<!-- csv -->
	<link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" integrity="sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p" crossorigin="anonymous"/>
</head>

<body class="menu_body">

	<nav role="navigation">
		<div id="menuToggle">

			<input type="checkbox" />

			<span></span>
			<span></span>
			<span></span>
			<ul id="menu">
				<a href="../home_page/index.php">
					<li><b>首頁</b></li>
				</a>
				<a href="../Water_view/water_1.php" target="_blank">
					<li><b>一段產水單元</b></li>
				</a>
				<a href="../Water_view/water_2.php" target="_blank">
					<li><b>二段產水單元</b></li>
				</a>
				<a href="../Instant_trend/index.php">
					<li><b>數據趨勢圖</b></li>
				</a>
				<a href="../history/index.php">
					<li><b>歷史警報</b></li>
				</a>
				<a href="./FM_moment_flow.php">
					<li><b>報表列印</b></li>
				</a>
			</ul>
		</div>
	</nav>
	<!-- partial -->
	<script src="./script.js"></script>



</body>


<body>
	<!-- partial:index.partial.html -->
	<?php if (isset($_POST['months']) and isset($_POST['years'])) {
		$years = $_POST["years"];
		$months = $_POST["months"];
	} else {
		$years = date('Y');
		$months = date('m');
	}
	?>

	<h1><span class="blue">&lt;</span>月報表 - 壓力計<span class="blue">&gt;</span> <span class="yellow"><?php echo $years . "年" . $months . "月"; ?></pan>
	</h1>

	<h6 class="frame">

		<button class="custom-btn btn-12" onclick="location='./FM_Cumulative_flow.php'"><span>Click!</span><span>FE累積流量月報表</span></button>
		<button class="custom-btn btn-12" onclick="location='./FM_moment_flow.php'"><span>Click!</span><span>FE瞬間流量月報表</span></button>
		<button class="custom-btn btn-12" onclick="location='./Conductivity_meter.php'"><span>Click!</span><span>導電度計月報表</span></button>
		<button class="custom-btn btn-12" onclick="location='./Pressure_gauge.php'"><span>Click!</span><span>壓力計月報表</span></button>
		<br>
		<br>

		<table align="center" border='0'>
			<tr>
				<td>
    <a onclick="window.open(' ./時間區間.php', '時間區間列印', config='height=500,width=500');" style="cursor:pointer ;">
        <i class='fas fa-file-csv' id='csv' style='font-size:55px;color:white;'></i>
    </a>
</td>
				<td>
					<!-- <a href="javascript:window.print();"> -->
					<a href="Pressure_gauge_print.php?month_p=<?php echo $months; ?>&year_p=<?php echo $years; ?>" target='_blank'>
						<button class="print-button"><span class="print-icon"></span></button>
					</a>
				</td>
				<form action="./Pressure_gauge.php" method="post">
					<td>
						<div class="select">
							<select name=years>
								<?php
								$sql_years = "SELECT DISTINCT y from pt ";
								$result_years = mysqli_query($link, $sql_years);
								while ($row_years = mysqli_fetch_array($result_years)) {
								?>
									<option value="<?php echo $row_years[0]; ?>"><?php echo $row_years[0]; ?>年</option>
								<?php }; ?>
							</select>
						</div>
					</td>
					<td></td>
					<td></td>
					<td></td>
					<td>
						<div class="select">
							<select name=months>
								<?php for ($i = 1; $i <= 12; $i++) { ?>
									<option value="<?php echo $i; ?>"><?php echo $i; ?>月</option>
								<?php } ?>
							</select>
						</div>
					</td>
					<td>
						<div class="wrap_submit">
							<button class="button_submit">Submit</button>
						</div>
					</td>

			</tr>
		</table>
		</form>
	</h6>

	<table class="container">
		<thead>
			<tr>
				<th>
					<h1>日期(月/日)</h1>
				</th>
				<th>
					<h1>PT-01<br><br>精密過濾器壓力</h1>
				</th>
				<th>
					<h1>PT-02<br><br>一段高壓泵入口壓力</h1>
				</th>
				<th>
					<h1>PT-03<br><br>一段RO單元入口壓力</h1>
				</th>
				<th>
					<h1>PT-04<br><br>二段RO單元入口壓力</h1>
				</th>
			</tr>
		</thead>
		<tbody>
			<?php

			include_once("./Pressure_gauge_preset_data.php");
			?>
		</tbody>
	</table>
	<!-- partial -->
	<script src="./script.js"></script>

</body>

<script>

    var interval = 3000;
    var time = 0;
  
	
    var las = function() {
	
        $.ajax({
            url: "../check.php",
            method: "POST",

            success: function(data) {
                //alert('5');
            },
            complete: function() {
                // Schedule the next
                setTimeout(las, interval);
            }
        });
    }
    las();

</script>

</html>